// Typ wyliczeniowy z operacjami skojarzonymi ze staymi
public abstract class Operation {
    private final String name;

    Operation(String name)   { this.name = name; }

    public String toString() { return this.name; }

    // Wykonaj operacj matematyczn dla biecego kontekstu
    abstract double eval(double x, double y);

    public static final Operation PLUS = new Operation("+") {
        double eval(double x, double y) { return x + y; }
    };

    public static final Operation MINUS = new Operation("-") {
        double eval(double x, double y) { return x - y; }
    };

    public static final Operation TIMES = new Operation("*") {
        double eval(double x, double y) { return x * y; }
    };

    public static final Operation DIVIDED_BY = 
        new Operation("/") {
            double eval(double x, double y) { return x / y; }
    };
}
